# Juristroid Legal Services Web Application

## Overview
Juristroid is a comprehensive legal services platform that provides online consultancy, government service applications, and document processing. The application serves as a digital gateway for various legal and administrative services in India.

## Core Features

### Public Pages
- **Home Page**: Overview of Juristroid's mission, key services, and contact information with prominent branding featuring logo, name, and tagline
- **Legal Help**: Online legal consultancy and case guidance request form
- **RTI Services**: Right to Information application form with document upload capability
- **PAN & Income Tax**: PAN card application and Income Tax return filing forms
- **GST Services**: GST registration and return filing forms
- **PF & ESI Services**: Provident Fund and Employee State Insurance registration and compliance forms
- **Society/Trust Registration**: Registration forms with renewal and return filing options
- **Accounting & Bookkeeping**: Business accounting and audit service request forms
- **Contact Us**: Office address, WhatsApp contact link, and email information
- **Payment Page**: Dedicated payment interface with UPI QR code, payment instructions, and "Mark as Paid" functionality

### Authentication System
- **OTP-based Login and Registration**: Users enter mobile number or email to initiate authentication
- **OTP Generation**: System generates a random 6-digit OTP for verification (simulated for demo purposes)
- **OTP Verification Flow**: Users receive OTP input form and must enter the correct code to proceed
- **Demo OTP Display**: For testing purposes, the generated OTP is displayed in the UI
- **Session Management**: Upon successful OTP verification, users are logged in or registered automatically
- **User Profile Management**: Application tracking and payment tab access after authentication
- **No Password Authentication**: Completely OTP-based system without traditional passwords

### Service Request Management
- All service forms collect user information and allow file uploads (PDF, JPG, DOC formats)
- Form submission generates service fee calculation
- Static UPI QR code display for payment with accompanying instructions
- Payment proof upload functionality (screenshots or transaction receipts)
- "Mark as Paid" button functionality to update payment status
- Application status tracking for users

### Payment System
- Static UPI QR code displayed on all payment-related pages and user profile payment tab
- QR code shows State Bank of India account details with UPI ID: 9279105982@ibl
- Payment instructions in English and Hindi: "Scan this QR code to pay securely via UPI (PhonePe, BHIM, GPay, Paytm, etc.)"
- "Mark as Paid" button updates payment status to pending verification
- Payment page accessible from navigation bar and service forms
- Responsive QR code display optimized for mobile and desktop

### Admin Dashboard
- View and manage all submitted applications
- Access to uploaded documents and user information
- Application status management (under review, approved, completed)
- Payment verification and tracking
- Payment status management (pending verification, verified, rejected)

## Backend Data Storage
- User profiles and authentication data with mobile/email identifiers
- OTP generation and verification records
- Service application submissions with form data
- Uploaded documents and files
- Payment records and proof uploads
- Payment status tracking (pending verification, verified, rejected)
- Application status and admin updates
- Service pricing and fee structures

## Backend Operations
- **OTP Generation**: Create random 6-digit codes for authentication
- **OTP Verification**: Validate user-entered OTP against generated code
- **User Session Management**: Create and manage authenticated user sessions
- **Demo OTP Handling**: Simulated OTP system for testing without external services
- File upload processing and storage
- Service fee calculation
- Payment status updates via "Mark as Paid" functionality
- Application status updates
- Admin management functions
- User application history retrieval
- Payment verification workflow

## User Interface
- Responsive design with professional legal service aesthetic
- Site header with Juristroid logo, stylized brand name, and Hindi tagline "आपका अपना वकील"
- Homepage hero section featuring centered logo, name, and tagline for strong visual branding
- **OTP Authentication Interface**: Clean login/registration forms with mobile/email input and OTP verification screens
- **Demo OTP Display**: Visual indication of generated OTP for testing purposes
- **Secure Authentication Flow**: Professional UI/UX for OTP-based verification process
- Structured navigation with service-specific icons and payment page access
- Clean form layouts with file upload components
- Payment interface with static UPI QR code display and responsive design
- User dashboard for application tracking with dedicated payment tab
- Admin interface for application and payment management
- English content with Hindi tagline support and bilingual payment instructions

## Branding Elements
- Primary logo displayed in site header navigation bar
- "Juristroid" name in stylized font consistent with brand colors
- Hindi tagline "आपका अपना वकील" displayed below site name
- Centered branding elements in homepage hero section
