import { useNavigate } from '@tanstack/react-router';
import { Button } from '@/components/ui/button';
import { Card, CardContent, CardDescription, CardHeader, CardTitle } from '@/components/ui/card';
import { Shield, Users, BookOpen } from 'lucide-react';

export default function HomePage() {
  const navigate = useNavigate();

  const services = [
    {
      title: 'Legal Help',
      description: 'Online legal consultancy and case guidance',
      icon: <img src="/assets/generated/legal-help-icon.dim_64x64.png" alt="Legal Help" className="h-12 w-12" />,
      path: '/legal-help',
      color: 'from-blue-500 to-blue-600',
    },
    {
      title: 'RTI Services',
      description: 'Right to Information application filing',
      icon: <img src="/assets/generated/rti-icon.dim_64x64.png" alt="RTI" className="h-12 w-12" />,
      path: '/rti-services',
      color: 'from-green-500 to-green-600',
    },
    {
      title: 'PAN & Income Tax',
      description: 'PAN card application and tax return filing',
      icon: <img src="/assets/generated/pan-tax-icon.dim_64x64.png" alt="PAN Tax" className="h-12 w-12" />,
      path: '/pan-tax',
      color: 'from-purple-500 to-purple-600',
    },
    {
      title: 'GST Services',
      description: 'GST registration and return filing',
      icon: <img src="/assets/generated/gst-icon.dim_64x64.png" alt="GST" className="h-12 w-12" />,
      path: '/gst-services',
      color: 'from-orange-500 to-orange-600',
    },
    {
      title: 'PF & ESI Services',
      description: 'Provident Fund and ESI registration',
      icon: <img src="/assets/generated/pf-esi-icon.dim_64x64.png" alt="PF ESI" className="h-12 w-12" />,
      path: '/pf-esi',
      color: 'from-red-500 to-red-600',
    },
    {
      title: 'Society/Trust Registration',
      description: 'Registration and compliance services',
      icon: <img src="/assets/generated/society-trust-icon.dim_64x64.png" alt="Society Trust" className="h-12 w-12" />,
      path: '/society-trust',
      color: 'from-indigo-500 to-indigo-600',
    },
    {
      title: 'Accounting & Bookkeeping',
      description: 'Business accounting and audit services',
      icon: <img src="/assets/generated/accounting-icon.dim_64x64.png" alt="Accounting" className="h-12 w-12" />,
      path: '/accounting',
      color: 'from-teal-500 to-teal-600',
    },
    {
      title: 'Contact Us',
      description: 'Get in touch with our team',
      icon: <img src="/assets/generated/contact-icon.dim_64x64.png" alt="Contact" className="h-12 w-12" />,
      path: '/contact',
      color: 'from-pink-500 to-pink-600',
    },
  ];

  return (
    <div className="container mx-auto px-4 py-8">
      <section className="mb-12">
        <div className="relative rounded-2xl overflow-hidden shadow-2xl bg-gradient-to-br from-[oklch(0.45_0.18_250)] via-[oklch(0.50_0.20_260)] to-[oklch(0.55_0.18_280)]">
          <div className="absolute inset-0 bg-[url('/assets/generated/hero-banner.dim_1200x600.png')] bg-cover bg-center opacity-10"></div>
          <div className="relative flex flex-col items-center justify-center py-20 px-8 text-center">
            <img 
              src="/assets/IMG-20250826-WA0003.jpg" 
              alt="Juristroid Logo" 
              className="h-32 w-32 mb-6 object-contain drop-shadow-2xl" 
            />
            <h1 className="text-6xl font-bold mb-3 text-white drop-shadow-lg brand-name">
              Juristroid
            </h1>
            <p className="text-2xl mb-8 text-white/95 font-medium hindi-tagline drop-shadow-md">
              आपका अपना वकील
            </p>
            <p className="text-xl mb-8 text-white/90 max-w-2xl">
              Your trusted partner for legal services, government applications, and compliance solutions in India.
            </p>
            <Button
              size="lg"
              variant="secondary"
              onClick={() => navigate({ to: '/legal-help' })}
              className="shadow-xl text-lg px-8 py-6 hover:scale-105 transition-transform"
            >
              Get Started
            </Button>
          </div>
        </div>
      </section>

      <section className="mb-12">
        <div className="text-center mb-8">
          <h2 className="text-3xl font-bold mb-3">Our Services</h2>
          <p className="text-muted-foreground max-w-2xl mx-auto">
            Comprehensive legal and administrative services to meet all your business and personal needs
          </p>
        </div>

        <div className="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-4 gap-6">
          {services.map((service, index) => (
            <Card
              key={index}
              className="hover:shadow-lg transition-all duration-300 cursor-pointer group border-2 hover:border-primary/50"
              onClick={() => navigate({ to: service.path })}
            >
              <CardHeader>
                <div className={`w-16 h-16 rounded-xl bg-gradient-to-br ${service.color} p-3 mb-3 group-hover:scale-110 transition-transform flex items-center justify-center`}>
                  {service.icon}
                </div>
                <CardTitle className="text-lg">{service.title}</CardTitle>
                <CardDescription>{service.description}</CardDescription>
              </CardHeader>
              <CardContent>
                <Button variant="ghost" className="w-full group-hover:bg-primary group-hover:text-primary-foreground transition-colors">
                  Learn More →
                </Button>
              </CardContent>
            </Card>
          ))}
        </div>
      </section>

      <section className="mb-12">
        <Card className="bg-gradient-to-br from-primary/5 to-primary/10 border-primary/20">
          <CardHeader>
            <CardTitle className="text-2xl">Why Choose Juristroid?</CardTitle>
          </CardHeader>
          <CardContent>
            <div className="grid grid-cols-1 md:grid-cols-3 gap-6">
              <div className="flex flex-col items-center text-center p-4">
                <div className="w-12 h-12 rounded-full bg-primary/10 flex items-center justify-center mb-3">
                  <Shield className="h-6 w-6 text-primary" />
                </div>
                <h3 className="font-semibold mb-2">Trusted & Secure</h3>
                <p className="text-sm text-muted-foreground">
                  Your data is protected with enterprise-grade security on the Internet Computer blockchain
                </p>
              </div>
              <div className="flex flex-col items-center text-center p-4">
                <div className="w-12 h-12 rounded-full bg-primary/10 flex items-center justify-center mb-3">
                  <Users className="h-6 w-6 text-primary" />
                </div>
                <h3 className="font-semibold mb-2">Expert Support</h3>
                <p className="text-sm text-muted-foreground">
                  Professional guidance from experienced legal and compliance experts
                </p>
              </div>
              <div className="flex flex-col items-center text-center p-4">
                <div className="w-12 h-12 rounded-full bg-primary/10 flex items-center justify-center mb-3">
                  <BookOpen className="h-6 w-6 text-primary" />
                </div>
                <h3 className="font-semibold mb-2">Easy Process</h3>
                <p className="text-sm text-muted-foreground">
                  Simple online forms and document upload for hassle-free service delivery
                </p>
              </div>
            </div>
          </CardContent>
        </Card>
      </section>
    </div>
  );
}
