import { Card, CardContent, CardDescription, CardHeader, CardTitle } from '@/components/ui/card';
import { Loader2, QrCode } from 'lucide-react';

interface UpiQrCodeProps {
  title?: string;
  description?: string;
  showInstructions?: boolean;
  className?: string;
}

export default function UpiQrCode({ 
  title = "UPI Payment", 
  description,
  showInstructions = true,
  className = ""
}: UpiQrCodeProps) {
  const qrCodeUrl = '/assets/generated/upi-qr-code.dim_300x300.png';
  const upiId = '9279105982@ibl';

  return (
    <Card className={className}>
      <CardHeader>
        <CardTitle className="flex items-center gap-2">
          <QrCode className="h-5 w-5" />
          {title}
        </CardTitle>
        {description && <CardDescription>{description}</CardDescription>}
      </CardHeader>
      <CardContent className="flex flex-col items-center space-y-4">
        <div className="bg-white p-4 rounded-lg shadow-sm">
          <img 
            src={qrCodeUrl} 
            alt="UPI QR Code for Payment" 
            className="w-64 h-64 object-contain"
          />
        </div>
        
        {showInstructions && (
          <div className="text-center space-y-2 max-w-md">
            <p className="text-sm font-medium">
              Scan this QR code to pay securely via UPI
            </p>
            <p className="text-sm text-muted-foreground">
              (PhonePe, BHIM, GPay, Paytm, etc.)
            </p>
            <p className="text-xs text-muted-foreground mt-2">
              इस QR कोड को स्कैन करें और UPI से सुरक्षित भुगतान करें
            </p>
            <div className="mt-4 p-3 bg-muted rounded-md">
              <p className="text-xs text-muted-foreground mb-1">UPI ID:</p>
              <p className="text-sm font-mono font-semibold">{upiId}</p>
            </div>
          </div>
        )}
      </CardContent>
    </Card>
  );
}
