import { RouterProvider, createRouter, createRoute, createRootRoute } from '@tanstack/react-router';
import { ThemeProvider } from 'next-themes';
import { Toaster } from '@/components/ui/sonner';
import Layout from './components/Layout';
import HomePage from './pages/HomePage';
import LegalHelpPage from './pages/LegalHelpPage';
import RTIServicesPage from './pages/RTIServicesPage';
import PANTaxPage from './pages/PANTaxPage';
import GSTServicesPage from './pages/GSTServicesPage';
import PFESIServicesPage from './pages/PFESIServicesPage';
import SocietyTrustPage from './pages/SocietyTrustPage';
import AccountingPage from './pages/AccountingPage';
import ContactPage from './pages/ContactPage';
import ProfilePage from './pages/ProfilePage';
import AdminDashboard from './pages/AdminDashboard';
import PaymentPage from './pages/PaymentPage';

const rootRoute = createRootRoute({
  component: Layout,
});

const indexRoute = createRoute({
  getParentRoute: () => rootRoute,
  path: '/',
  component: HomePage,
});

const legalHelpRoute = createRoute({
  getParentRoute: () => rootRoute,
  path: '/legal-help',
  component: LegalHelpPage,
});

const rtiRoute = createRoute({
  getParentRoute: () => rootRoute,
  path: '/rti-services',
  component: RTIServicesPage,
});

const panTaxRoute = createRoute({
  getParentRoute: () => rootRoute,
  path: '/pan-tax',
  component: PANTaxPage,
});

const gstRoute = createRoute({
  getParentRoute: () => rootRoute,
  path: '/gst-services',
  component: GSTServicesPage,
});

const pfEsiRoute = createRoute({
  getParentRoute: () => rootRoute,
  path: '/pf-esi',
  component: PFESIServicesPage,
});

const societyTrustRoute = createRoute({
  getParentRoute: () => rootRoute,
  path: '/society-trust',
  component: SocietyTrustPage,
});

const accountingRoute = createRoute({
  getParentRoute: () => rootRoute,
  path: '/accounting',
  component: AccountingPage,
});

const contactRoute = createRoute({
  getParentRoute: () => rootRoute,
  path: '/contact',
  component: ContactPage,
});

const profileRoute = createRoute({
  getParentRoute: () => rootRoute,
  path: '/profile',
  component: ProfilePage,
});

const adminRoute = createRoute({
  getParentRoute: () => rootRoute,
  path: '/admin',
  component: AdminDashboard,
});

const paymentRoute = createRoute({
  getParentRoute: () => rootRoute,
  path: '/payment',
  component: PaymentPage,
});

const routeTree = rootRoute.addChildren([
  indexRoute,
  legalHelpRoute,
  rtiRoute,
  panTaxRoute,
  gstRoute,
  pfEsiRoute,
  societyTrustRoute,
  accountingRoute,
  contactRoute,
  profileRoute,
  adminRoute,
  paymentRoute,
]);

const router = createRouter({ routeTree });

declare module '@tanstack/react-router' {
  interface Register {
    router: typeof router;
  }
}

export default function App() {
  return (
    <ThemeProvider attribute="class" defaultTheme="light" enableSystem>
      <RouterProvider router={router} />
      <Toaster />
    </ThemeProvider>
  );
}
